﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Drawing2D;
using Azyobuzi.りすにんぐついったー.Properties;

namespace Azyobuzi.りすにんぐついったー
{
    public partial class SettingsForm : StylishForm
    {
        public SettingsForm()
        {
            InitializeComponent();

            //設定読み込み
            var s = SettingsXml.Instance;
            intervalBox.Value = s.interval;
            tempBox.Text = s.template;
        }

        private void authBtn_Click(object sender, EventArgs e)
        {
            var auth = new AuthForm();
            auth.ShowDialog();
            auth.Dispose();
        }

        private void cancelBtn_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void okBtn_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(tempBox.Text))
            {
                MessageBox.Show("投稿内容を入力してください。","入力エラー",MessageBoxButtons.OK,MessageBoxIcon.Error);
                return;
            }
            
            var s = SettingsXml.Instance;
            s.interval = (uint)intervalBox.Value;
            s.template = tempBox.Text;

            this.DialogResult = DialogResult.OK;
            this.Close();
        }
    }
}
